/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationImmutability;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class PriceList {

    //A collection of products that belong on our price list.
    private List<Product> list = new ArrayList<>();

    public List<Product> getList() {
        return list;
    }

    //Adds a product to our price list (provided their is no other product with that name).
    public void addProduct(Product newProduct) {
        boolean exists=false;
        //If a product with this name already exists print out a message and stop.
        for (Product p : list) {
            if (p.getName().equals(newProduct.getName())) {
                System.out.println("A product already exists with that name.");
                exists=true;
            }
        }
        if (!exists) {
            list.add(newProduct);
        } else {}
    }

    //Removes a product on our price list based on the name of the product.
    public void removeProduct(String productName) {
        for (Product p : list) {
            if (p.getName().equals(productName)) {
                list.remove(p);
                return;
            }
        }
    }

    public void printList() {
        //Print out the price list
        System.out.println("== Price list (current as of " + LocalDate.now() + ") ==");

        //For each product in our list, print out the product details
        for (Product p : list) {
            //Put a blank line between each product
            System.out.println();
            //Get the product to print out the details
            p.printProduct();
        }
        System.out.println("== End of Price List ==");
    }
}
